<?php
// ***********************************************************************************************
// Office 2007 Blue Stylesheet
// -----------------------------------------------------------------------------------------------
//ini_set('zlib.output_compression', 'On');
session_start();

$approot = '../../';

//check for config file.
if (file_exists($approot.'_includes/config.inc.php')) {
	// now that all is well, include config files.
	require_once($approot.'_includes/config.inc.php');
	require_once($approot.'_includes/settings.inc.php');
}

header("Content-type: text/css");
?>
body {
	font-size:100%;
	margin:0;
	padding:0;
	font-family:Arial, Helvetica, sans-serif;
	background-color:#7D7D7D;
	color:#000;
}

#wrapper {
	position:relative;
	font-size:12px;
	margin:5px;
	padding:0;
}

#login_box {
	position:absolute;
	x-index:100;
	top:54px;
	left:211px;
	border:1px solid #868686;
	background-color:#DFDFDF;
	overflow:hidden;
	margin:0;
}

#login_box div.inner{
	margin:0;
	width:200px;
	height:100px;
}
#login_box div.inner p {
	margin:0;
	padding:5px 2px 2px 2px;
	clear:both;
}
#login_box div.inner p input.txt {
	border:1px solid #949494;
	width:120px;
	float:right;
}

#views_box {
	position:absolute;
	x-index:100;
	top:54px;
	left:152px;
	border:1px solid #868686;
	background-color:#DFDFDF;
	overflow:hidden;
	margin:0;
}
#views_box div.inner{
	margin:0;
	width:100px;
}
#views_box ul {
	list-style:none;
	margin:0;
	padding:0;
}
#views_box ul li {
	padding:0;
	margin:0;
}
#views_box ul li a {
	display:block;
	padding:3px;
	border:1px solid #DFDFDF;
}
#views_box ul li a:hover {
	background-color:#F7D478;
	border:1px solid #F09B1E;
	text-decoration:none;
}

/* --- */ 

#shares_box {
	position:absolute;
	x-index:100;
	top:54px;
	left:83px;
	border:1px solid #868686;
	background-color:#DFDFDF;
	overflow:hidden;
	margin:0;
}
#shares_box div.inner{
	margin:0;
	height:auto;
}
#shares_box ul {
	list-style:none;
	margin:0;
	padding:0;
}
#shares_box ul li {
	padding:0;
	margin:0;
}
#shares_box ul li a {
	display:block;
	padding:3px;
	border:1px solid #DFDFDF;
}
#shares_box ul li a:hover {
	background-color:#F7D478;
	border:1px solid #F09B1E;
	text-decoration:none;
}


/* -- */

#fileops_box {
	position:absolute;
	x-index:100;
	top:54px;
	left:270px;
	border:1px solid #868686;
	background-color:#DFDFDF;
	overflow:hidden;
	width:auto;
	margin:0;
}
#fileops_box div.inner{
	margin:0;
	width:auto;
	height:auto;
}
#fileops_box ul {
	list-style:none;
	margin:0;
	padding:0;
}
#fileops_box ul li {
	padding:0;
	margin:0;
}
#fileops_box ul li a {
	display:block;
	padding:3px;
	border:1px solid #DFDFDF;
}
#fileops_box ul li a:hover {
	background-color:#F7D478;
	border:1px solid #F09B1E;
	text-decoration:none;
}


/* --------------- HEAD ----------------- */
#head {
	position:relative;
	margin:0;
	padding:0;
	height:59px;
	background:url("<?php echo THEMEDIR; ?>images/head_bg.gif") left top repeat-x;
}

#head h2 {
	font-size:12px;
	font-weight:normal;
	text-align:center;
	margin:0;
	padding:7px 0 0 0;
	color:#fff;
}

#head_left, #head_right {
	position:absolute;
	height:59px;
	top:0;
}

#head_left {
	left:0;
	background:url("<?php echo THEMEDIR; ?>images/head_left.gif") left top no-repeat;
	width:50px;
}

#head_right {
	right:0;
	background:url("<?php echo THEMEDIR; ?>images/head_right.gif") left top no-repeat;
	width:5px;
}


#menu {
	position:absolute;
	top:22px;
	left:30px;
	font-size:93%;
	line-height:normal;
}
#menu ul {
	margin:0;
	padding:10px 10px 0 50px;
	list-style:none;
}
#menu li {
	display:inline;
	margin:0;
	padding:0;
}
#menu a {
	float:left;
	background:url("<?php echo THEMEDIR; ?>images/menu_tab_left.gif") no-repeat left top;
	margin:0;
	padding:0 0 0 9px;
	text-decoration:none;
}
#menu a span {
	float:left;
	display:block;
	background:url("<?php echo THEMEDIR; ?>images/menu_tab_right.gif") no-repeat right top;
	padding:5px 15px 4px 9px;
	color:#fff;
}
/* Commented Backslash Hack hides rule from IE5-Mac \*/
#menu a span {float:none;}
/* End IE5-Mac hack */
#menu a:hover span, #menu a.selected span {
	color:#000;
}
#menu a:hover, #menu a.selected {
	background-position:0% -25px;
}
#menu a:hover span, #menu a.selected span {
	background-position:100% -25px;
}

/* --------------- END HEAD ----------------- */


/* --------------- MAIN ----------------- */

#main {
	position:relative;
	margin:0;
	padding:0 0 5px 0;
	background-color:#EAEAEA;
}

#main_left, #main_right {
	position:absolute;
	width:6px;
	top:0;
}

#main_left {
	left:0;
	background:url("<?php echo THEMEDIR; ?>images/main_left.gif") left top repeat-y;
}

#main_right {
	right:-1px;
	background:url("<?php echo THEMEDIR; ?>images/main_right.gif") left top repeat-y;
}

#main_head { /* space for the P */
	position:relative;
	height:20px;
	font-size:14px;
}

#main_head p { /* ie: Files > Applications > 3dsmax */
	margin:0;
	padding:2px 5px 0 10px;
}

#main_container { /* white content box */
	background-color:#fff;
	border:1px solid #949494;
	margin:0;
	padding:0;
}

#main_content { /* folder contents */ 
	background-color:#fff;
	overflow:auto;
	margin:0 5px 0 5px;
	padding:5px;
	position:relative;
}

#main_content p, #main_content h2, #main_content h3, #main_content h1, #main_content h4 {
	margin-left:5px;
}

#main_loading {
	position:absolute;
	top:0;
	left:0;
	width:56px;
	height:21px;
	z-index:100;
	background:url("<?php echo THEMEDIR; ?>images/loading.gif") left top no-repeat;
}

p.img_thumbnail {
	display:none;
	visibility:hidden;
}

/* --------------- END MAIN ----------------- */


/* --------------- FOOT ----------------- */
#foot {
	position:relative;
	margin:0;
	padding:0;
	height:23px;
	background:url("<?php echo THEMEDIR; ?>images/foot_bg.gif") left top repeat-x;
}

#foot_left, #foot_right {
	position:absolute;
	height:23px;
	top:0;
}

#foot_left p, #foot_right p {
	margin:0;
	padding:4px 10px 0 10px;
}

#foot_left {
	left:0;
	background:url("<?php echo THEMEDIR; ?>images/foot_left.gif") left top no-repeat;
	width:45%;
	color:#aeaeae;
}

#foot_right {
	right:0;
	background:url("<?php echo THEMEDIR; ?>images/foot_right.gif") right top no-repeat;
	width:45%;
	text-align:right;
	color:#999;
}


/* --------------- END FOOT ----------------- */


/* --------------- LINKS ----------------- */
a {
	text-decoration:none;
	color:#333;
}

a:hover {
	text-decoration:underline;
	color:#888;
}
/* --------------- END LINKS ----------------- */

/* --------------- UPLOAD BOX ---------------- */
#app_upload_box {
	font-size:12px;
	z-index:102;
	position:absolute;
	width:385px;
	height:400px;
	background:url("<?php echo THEMEDIR; ?>images/upload_bg.gif") left top no-repeat;
	color:#fff;
}

#app_upload_box div.body{
	overflow:auto;
	height:327px;
	margin:50px 2px 0 2px;
	text-align:justify;	
}

#app_upload_box div.body ul{
	list-style:none;
	margin:5px;
}

#app_upload_box div.body ul li{
	width:170px;
	float:left;
	font-weight:bold;
}

#app_upload_box div.body ol li {
	color:#000;
}
#app_upload_box div.body ol li {
	margin:0 0 10px 0;
}

#app_upload_box div.body ol li p.uploadNotify_uploading {
	background:url("<?php echo THEMEDIR; ?>images/loading.gif") left top no-repeat;
	padding-left:65px;
	line-height:21px;
}

#app_upload_box div.body p.note {
	margin-left:40px;
}
#app_upload_box div.body p.btns {
	text-align:center;
}

input.button {
/*	width:auto; */
	position:relative;
	margin:0 4px 0 4px;
	padding:1px 0 1px 0;
	color:#000;
	font-weight:bold;
	background:url("<?php echo THEMEDIR; ?>images/button.gif") left top no-repeat;
	height:22px;
	width:120px;
	cursor:pointer;
	_cursor:hand;
	border:0;
	text-decoration:none;
}

#upload_ol_wrapper {
	height:240px;
	position:relative;
	overflow:auto;
	background-color:#E1E1E1;
	margin:0 1px 0 1px;
	border-bottom:1px solid #535353;
}

/* --------------- APP ERROR & dialog ----------------- */
#app_error {
	position:absolute;
	top:0;
	left:0;
	background-color:#000;
	z-index:101;
}
#app_error_text, #app_dialog_text {
	font-size:12px;
	z-index:102;
	position:absolute;
	width:385px;
	height:137px;
}
#app_error_text{
	background:url("<?php echo THEMEDIR; ?>images/app_error.gif") left top no-repeat;
	color:#000;
}

#app_dialog_text {
	background:url("<?php echo THEMEDIR; ?>images/app_dialog.gif") left top no-repeat;
	color:#fff;
}

#app_error_text p.head, #app_dialog_text p.head, #app_upload_box p.head {
	position:absolute;
	top:10px;
	left:60px;
	margin:0;
	padding:0;
	font-weight:bold;
}
#app_error_text p, #app_dialog_text p{
	margin:0;
	padding:40px 10px 10px 50px;
}

#app_error_text p, #app_dialog_text p input{
	width:275px;
}

#app_dialog_text p.btns input {
/*	width:auto; */
	position:relative;
	margin:0 4px 0 4px;
	padding:1px 0 1px 0;
	color:#000;
	font-weight:bold;
	background:url("<?php echo THEMEDIR; ?>images/button.gif") left top no-repeat;
	height:22px;
	width:120px;
	cursor:pointer;
	_cursor:hand;
	border:0;
	text-decoration:none;
}
#app_dialog_text p.btns{
	margin:0;
	text-align:center;
	padding:5px 10px 10px 5px;
}

#app_error_text p.foot, #app_dialog_text p.foot{
	position:absolute;
	bottom:4px;
	left:15px;
	margin:0;
	padding:0;
	font-weight:bold;
}

/* --------------- END APP ERROR ----------------- */

/* -- preview pane -- */
#preview_pane {
	position:relative;
	width:200px;
	margin:0 0 0 4px;
	padding:0;
	background:#959595 url("<?php echo THEMEDIR; ?>images/previewpane_bg.jpg") left top repeat-x;
	border-right:1px solid #949494;
	float:left;
	display:none;
	overflow:hidden;
}

#preview_pane div.container {
	width:200px;
	color:#000;
}

#preview_pane a#hide_pp {
	position:absolute;
	display:block;
	margin:0;
	padding:0;
	text-align:center;
	width:200px;
	left:0;
	bottom:5px;
	color:#555;
}

#preview_pane a#hide_pp:hover {
	color:#333;
}

#preview_loading {
	position:absolute;
	top:0;
	left:0;
	width:56px;
	height:21px;
	z-index:100;
	background:url("<?php echo THEMEDIR; ?>images/loading.gif") left top no-repeat;
}

#preview_pane_container div.image {
	width:170px;
	height:170px;
	margin:10px auto 10px auto;
	border:1px solid #949494;
	background-color:#949494;
}

#preview_pane_container div.image img {
	margin:0 auto 0 auto;
}

#preview_pane_container p.name {
	text-align:center;
	font-weight:bold;
}

#preview_pane_container p.details {
	padding:2px 4px 2px 4px;
	margin:0;
}

#preview_pane_container p.download {
	text-align:center;
}

#preview_pane_container div.image_dir {
	background:url("<?php echo THEMEDIR; ?>images/preview/folder.jpg") left top no-repeat;
}
#preview_pane_container div.image_audio {
	background:url("<?php echo THEMEDIR; ?>images/preview/audio.jpg") left top no-repeat;
}
#preview_pane_container div.image_video {
	background:url("<?php echo THEMEDIR; ?>images/preview/video.jpg") left top no-repeat;
}
#preview_pane_container div.image_image {
	background:url("<?php echo THEMEDIR; ?>images/preview/image.jpg") left top no-repeat;
}
#preview_pane_container div.image_file {
	background:url("<?php echo THEMEDIR; ?>images/preview/file.jpg") left top no-repeat;
}

/* -- views - details -- */

#main_content.view_details ul#share_listing {
	list-style:none;
	margin:0;
	padding:0;
}

#main_content.view_details ul#share_listing li {
	list-style:none;
	margin:0;
	padding:2px 0 0 20px;
	position:relative;
	top:0;
	height:18px;
	cursor:pointer;
	_cursor:hand;
	background-position:left 2px;
	background-repeat:no-repeat;
}

#main_content.view_details ul#share_listing li p {
	margin:0;
	padding:0;
	display:inline;
	position:absolute;
}

#main_content.view_details ul#share_listing li.file p.size{
	right:10px;
}

#main_content.view_details ul#share_listing li.file p.type{
	right:100px;
}

#main_content.view_details ul#share_listing li.dir {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/folder.gif");
}

#main_content.view_details ul#share_listing li.file {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/unknown.gif");
}

#main_content.view_details ul#share_listing li.type_avi {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/avi.gif");
}

#main_content.view_details ul#share_listing li.type_psd {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/psd.gif");
}

#main_content.view_details ul#share_listing li.type_bmp {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/bmp.gif");
}

#main_content.view_details ul#share_listing li.type_doc {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/doc.gif");
}

#main_content.view_details ul#share_listing li.type_exe {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/exe.gif");
}

#main_content.view_details ul#share_listing li.type_mmap {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/mmap.gif");
}

#main_content.view_details ul#share_listing li.type_mov {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/mov.gif");
}

#main_content.view_details ul#share_listing li.type_pdf {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/pdf.gif");
}

#main_content.view_details ul#share_listing li.type_php {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/php.gif");
}

#main_content.view_details ul#share_listing li.type_ppt {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/ppt.gif");
}

#main_content.view_details ul#share_listing li.type_pub {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/pub.gif");
}

#main_content.view_details ul#share_listing li.type_ttf {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/ttf.gif");
}

#main_content.view_details ul#share_listing li.type_txt {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/txt.gif");
}

#main_content.view_details ul#share_listing li.type_xls {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/xls.gif");
}

#main_content.view_details ul#share_listing li.type_zip {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/zip.gif");
}

#main_content.view_details ul#share_listing li.type_mp3, #main_content.view_details ul#share_listing li.type_mp2, #main_content.view_details ul#share_listing li.type_wav, #main_content.view_details ul#share_listing li.type_wmv {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/mp3.gif");
}

#main_content.view_details ul#share_listing li.type_jpg, #main_content.view_details ul#share_listing li.type_gif, #main_content.view_details ul#share_listing li.type_png {
	background-image:url("<?php echo THEMEDIR; ?>images/views/details/jpg.gif");
}

/* -- end views - details -- */

/* -- views - large icons -- */

#main_content.view_large ul#share_listing {
	list-style:none;
	margin:0;
	padding:0;
}

#main_content.view_large ul#share_listing li {
	list-style:none;
	margin:0;
	padding:0;
	position:relative;
	top:0;
	height:105px;
	width:120px;
	cursor:pointer;
	_cursor:hand;
	background-position:50% 5px;
	background-repeat:no-repeat;
	float:left;
	overflow:hidden;
}

#main_content.view_large ul#share_listing li p {
	margin:0;
	padding:55px 0 0 0;
	text-align:center;
}

#main_content.view_large ul#share_listing li.file p.size, #main_content.view_large ul#share_listing li.file p.type{
	display:none;
}


#main_content.view_large ul#share_listing li.dir {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/folder.gif");
}

#main_content.view_large ul#share_listing li.file {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/unknown.gif");
}

#main_content.view_large ul#share_listing li.type_avi, #main_content.view_large ul#share_listing li.type_divx {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/avi.gif");
}

#main_content.view_large ul#share_listing li.type_wmv {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/wmv.gif");
}

#main_content.view_large ul#share_listing li.type_mpg, #main_content.view_large ul#share_listing li.type_mpeg {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/mpg.gif");
}

#main_content.view_large ul#share_listing li.type_psd {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/psd.gif");
}

#main_content.view_large ul#share_listing li.type_bmp {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/bmp.gif");
}

#main_content.view_large ul#share_listing li.type_doc {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/doc.gif");
}

#main_content.view_large ul#share_listing li.type_exe {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/exe.gif");
}

#main_content.view_large ul#share_listing li.type_mmap {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/mmap.gif");
}

#main_content.view_large ul#share_listing li.type_mov {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/mov.gif");
}

#main_content.view_large ul#share_listing li.type_pdf {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/pdf.gif");
}

#main_content.view_large ul#share_listing li.type_php {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/php.gif");
}

#main_content.view_large ul#share_listing li.type_ppt {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/ppt.gif");
}

#main_content.view_large ul#share_listing li.type_pub {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/pub.gif");
}

#main_content.view_large ul#share_listing li.type_ttf {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/ttf.gif");
}

#main_content.view_large ul#share_listing li.type_txt {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/txt.gif");
}

#main_content.view_large ul#share_listing li.type_xls {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/xls.gif");
}

#main_content.view_large ul#share_listing li.type_zip {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/zip.gif");
}

#main_content.view_large ul#share_listing li.type_mp3, #main_content.view_large ul#share_listing li.type_mp2, #main_content.view_large ul#share_listing li.type_wav, #main_content.view_large ul#share_listing li.type_m4a {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/mp3.gif");
}

#main_content.view_large ul#share_listing li.type_jpg, #main_content.view_large ul#share_listing li.type_gif, #main_content.view_large ul#share_listing li.type_png {
	background-image:url("<?php echo THEMEDIR; ?>images/views/large/jpg.gif");
}

/* -- end views - large icons -- */

/* -- views - thumbnails -- */

#main_content.view_thumbnails ul#share_listing {
	list-style:none;
	margin:0;
	padding:0;
}

#main_content.view_thumbnails ul#share_listing li {
	list-style:none;
	margin:0;
	padding:0;
	position:relative;
	top:0;
	height:139px;
	width:124px;
	cursor:pointer;
	_cursor:hand;
	background-position:50% 5px;
	background-repeat:no-repeat;
	float:left;
	overflow:hidden;
}

#main_content.view_thumbnails ul#share_listing li img {
	width:94px;
	height:94px;
	border:1px solid #ccc;
	position:absolute;
	top:4px;
	left:13px;
}

#main_content.view_thumbnails ul#share_listing li p {
	margin:0;
	padding:103px 0 0 0;
	text-align:center;
}

#main_content.view_thumbnails ul#share_listing li.file p.size, #main_content.view_thumbnails ul#share_listing li.file p.type{
	display:none;
}


#main_content.view_thumbnails ul#share_listing li.dir {
	background-image:url("<?php echo THEMEDIR; ?>images/views/thumbnails/folder.jpg");
}

#main_content.view_thumbnails ul#share_listing li.cat_image {
	background-image:url("<?php echo THEMEDIR; ?>images/views/thumbnails/image.jpg");
}

#main_content.view_thumbnails ul#share_listing li.cat_video {
	background-image:url("<?php echo THEMEDIR; ?>images/views/thumbnails/video.jpg");
}

#main_content.view_thumbnails ul#share_listing li.cat_audio {
	background-image:url("<?php echo THEMEDIR; ?>images/views/thumbnails/audio.jpg");
}

#main_content.view_thumbnails ul#share_listing li.cat_file {
	background-image:url("<?php echo THEMEDIR; ?>images/views/thumbnails/file.jpg");
}

/* -- end views - thumbnails -- */

/* -- views - small icons -- */

#main_content.view_small ul#share_listing {
	list-style:none;
	margin:0;
	padding:0;
}

#main_content.view_small ul#share_listing li {
	list-style:none;
	margin:0;
	padding:0;
	position:relative;
	top:0;
	height:85px;
	width:100px;
	cursor:pointer;
	_cursor:hand;
	background-position:50% 5px;
	background-repeat:no-repeat;
	float:left;
	overflow:hidden;
}

#main_content.view_small ul#share_listing li p {
	margin:0;
	padding:40px 0 0 0;
	text-align:center;
}

#main_content.view_small ul#share_listing li.file p.size, #main_content.view_small ul#share_listing li.file p.type{
	display:none;
}


#main_content.view_small ul#share_listing li.dir {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/folder.gif");
}

#main_content.view_small ul#share_listing li.file {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/unknown.gif");
}

#main_content.view_small ul#share_listing li.type_avi, #main_content.view_small ul#share_listing li.type_divx {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/avi.gif");
}

#main_content.view_small ul#share_listing li.type_wmv {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/wmv.gif");
}

#main_content.view_small ul#share_listing li.type_mpg, #main_content.view_small ul#share_listing li.type_mpeg {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/mpg.gif");
}

#main_content.view_small ul#share_listing li.type_psd {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/psd.gif");
}

#main_content.view_small ul#share_listing li.type_bmp {
	background-image:url(<?php echo THEMEDIR; ?>images/views/small/bmp.gif");
}

#main_content.view_small ul#share_listing li.type_doc {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/doc.gif");
}

#main_content.view_small ul#share_listing li.type_exe {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/exe.gif");
}

#main_content.view_small ul#share_listing li.type_mmap {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/mmap.gif");
}

#main_content.view_small ul#share_listing li.type_mov {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/mov.gif");
}

#main_content.view_small ul#share_listing li.type_pdf {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/pdf.gif");
}

#main_content.view_small ul#share_listing li.type_php {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/php.gif");
}

#main_content.view_small ul#share_listing li.type_ppt {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/ppt.gif");
}

#main_content.view_small ul#share_listing li.type_pub {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/pub.gif");
}

#main_content.view_small ul#share_listing li.type_ttf {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/ttf.gif");
}

#main_content.view_small ul#share_listing li.type_txt {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/txt.gif");
}

#main_content.view_small ul#share_listing li.type_xls {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/xls.gif");
}

#main_content.view_small ul#share_listing li.type_zip {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/zip.gif");
}

#main_content.view_small ul#share_listing li.type_mp3, #main_content.view_small ul#share_listing li.type_mp2, #main_content.view_small ul#share_listing li.type_wav, #main_content.view_small ul#share_listing li.type_m4a {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/mp3.gif");
}

#main_content.view_small ul#share_listing li.type_jpg, #main_content.view_small ul#share_listing li.type_gif, #main_content.view_small ul#share_listing li.type_png {
	background-image:url("<?php echo THEMEDIR; ?>images/views/small/jpg.gif");
}

/* -- end views - small icons -- */




a.button {
	position:relative;
	display:block;
	margin:0 auto 0 auto;
	padding:3px 0 1px 0;
	color:#000;
	font-weight:bold;
	background:url("<?php echo THEMEDIR; ?>images/button.gif") left top no-repeat;
	height:18px;
	width:120px;
	cursor:pointer;
	_cursor:hand;
	text-decoration:none;
}

a.button:hover {
	text-decoration:none;
	background-position:left bottom;
}

/* this must got at the bottom of the file */
#main_content.view_details ul#share_listing li.hover, #main_content.view_small ul#share_listing li.hover, #main_content.view_large ul#share_listing li.hover {
	background-color:#f8f8f8;
}

#main_content.view_details ul#share_listing li.selected, #main_content.view_small ul#share_listing li.selected, #main_content.view_large ul#share_listing li.selected {
	background-color:#E7E7E7;
}


#fileops_link, #logout_link, #admin_link, #upload_link, #views_link {
	display:none;
}


.hidden {
	visibility:hidden;
	display:none;
	width:1px;
  height:1px;
  border:none;
}

p.uploadNotify_failed {
	color:#f00;
}